

(function() {
    'use strict';

    // 儲存在 localStorage 的 key
    var STORAGE_KEY = 'NGP_NewGamePlus_Data';

    // 全域：讀取已有的 NGP 資料
    window.NGP_Data = loadNgpData();

    //--------------------------------------------------------------------------
    // 讀取 / 儲存 / 清除 NGP 資料
    //--------------------------------------------------------------------------

    function loadNgpData() {
        try {
            var json = localStorage.getItem(STORAGE_KEY);
            if (json) {
                return JSON.parse(json);
            }
        } catch (e) {
            console.error('讀取 NGP 資料失敗：', e);
        }
        // 預設沒有通關資料
        return {
            finished: false,
            switches: {},
            items: {},
            gold: 0
        };
    }

    function saveNgpData() {
        try {
            localStorage.setItem(STORAGE_KEY, JSON.stringify(window.NGP_Data));
        } catch (e) {
            console.error('儲存 NGP 資料失敗：', e);
        }
    }

    // 在通關彩蛋房間呼叫：保存目前狀態作為二周目資料
    window.NGP_SaveForNextLoop = function() {
        if (!$gameSwitches || !$gameParty) return;

        // 要保留的開關 ID
        var keepSwitchIds = [25, 222];
        for (var i = 241; i <= 276; i++) {
            keepSwitchIds.push(i);
        }

        var swData = {};
        keepSwitchIds.forEach(function(id) {
            swData[id] = $gameSwitches.value(id);
        });

        // 只保留「普通道具」（itypeId === 1）
        var itemData = {};
        var partyItems = $gameParty._items; // { itemId: 數量 }
        for (var id in partyItems) {
            if (partyItems.hasOwnProperty(id)) {
                var itemId = Number(id);
                var item = $dataItems[itemId];
                if (item && item.itypeId === 1) { // 普通道具
                    itemData[itemId] = partyItems[id];
                }
            }
        }

        var gold = $gameParty.gold();

        window.NGP_Data = {
            finished: true,
            switches: swData,
            items: itemData,
            gold: gold
        };

        saveNgpData();
        console.log('NGP_SaveForNextLoop: 已儲存二周目用資料。');
    };

    var NGP_AUTO_SAVE_SWITCH_ID = 222;

var _NGP_Game_Switches_setValue = Game_Switches.prototype.setValue;
Game_Switches.prototype.setValue = function(switchId, value) {
    var old = this.value(switchId);     // 記錄原本的值（true / false）

    _NGP_Game_Switches_setValue.call(this, switchId, value);

    // 只有從 OFF -> ON 的瞬間才紀錄
    if (switchId === NGP_AUTO_SAVE_SWITCH_ID && value && !old) {
        if (typeof NGP_SaveForNextLoop === 'function' && $gameParty) {
            NGP_SaveForNextLoop();
        }
    }
};

    // 手動清除 NGP 資料用
    window.NGP_ClearData = function() {
        window.NGP_Data = {
            finished: false,
            switches: {},
            items: {},
            gold: 0
        };
        try {
            localStorage.removeItem(STORAGE_KEY);
        } catch (e) {
            console.error('清除 NGP 資料失敗：', e);
        }
        console.log('NGP_ClearData: 已清除二周目資料。');
    };

    //--------------------------------------------------------------------------
    // 套用二周目資料到目前新遊戲
    //--------------------------------------------------------------------------

    function applyNgpData() {
        if (!window.NGP_Data || !window.NGP_Data.finished) return;

        // 開關
        var swData = window.NGP_Data.switches || {};
        Object.keys(swData).forEach(function(key) {
            var id = Number(key);
            $gameSwitches.setValue(id, !!swData[key]);
        });

        // 普通道具
        var items = window.NGP_Data.items || {};
        Object.keys(items).forEach(function(key) {
            var itemId = Number(key);
            var item = $dataItems[itemId];
            if (item) {
                var amount = items[key];
                $gameParty.gainItem(item, amount);
            }
        });

        // 金錢（重設成通關時的金額）
        var gold = window.NGP_Data.gold || 0;
        $gameParty.loseGold($gameParty.gold());
        $gameParty.gainGold(gold);

        console.log('applyNgpData: 已套用二周目資料。');
    }

    //--------------------------------------------------------------------------
    // 文字依語言切換：問題 & 選項
    //--------------------------------------------------------------------------

    function ngpTexts() {
        var lang = 'CHI';
        if (typeof ConfigManager !== 'undefined' && ConfigManager.Language) {
            lang = ConfigManager.Language;
        }

        if (lang === 'JAP') {
            return {
                question: '前周回のセーブデータを引き継ぎますか？',
                yes:      'セーブデータを引き継いで始める',
                no:       '引き継がずに最初から始める'
            };
        } else {
            // 預設中文
            return {
                question: '要继承上一轮的存档吗？',
                yes:      '继承资料开始游戏',
                no:       '不继承开始新游戏'
            };
        }
    }

    //--------------------------------------------------------------------------
    // New Game 時，記錄「進入新遊戲後要問一次」
    //--------------------------------------------------------------------------

var _Scene_Title_commandNewGame = Scene_Title.prototype.commandNewGame;
Scene_Title.prototype.commandNewGame = function() {
    // ★ 如果完全沒有任何存檔，視為全新環境 → 自動清除二周目資料
    if (!DataManager.isAnySavefileExists() && window.NGP_ClearData) {
        NGP_ClearData();
    }

    _Scene_Title_commandNewGame.call(this);
    // 原本的處理會建立新遊戲並跳到地圖

    if ($gameSystem) {
        if (window.NGP_Data && window.NGP_Data.finished) {
            // 有通關紀錄 → 這次進地圖要問
            $gameSystem._ngpShouldAskOnStart = true;
        } else {
            $gameSystem._ngpShouldAskOnStart = false;
        }
    }
};

    //--------------------------------------------------------------------------
    // 進入地圖後，用普通對話框 + 選項來詢問是否繼承
    //--------------------------------------------------------------------------

    var _Scene_Map_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function() {
        _Scene_Map_start.call(this);
        this.checkNgpQuestionOnNewGame();
    };

    Scene_Map.prototype.checkNgpQuestionOnNewGame = function() {
        if (!$gameSystem) return;
        if (!$gameSystem._ngpShouldAskOnStart) return;

        // 問一次就清 flag（但不清資料，之後 New Game 會再設回來）
        $gameSystem._ngpShouldAskOnStart = false;

        if (!window.NGP_Data || !window.NGP_Data.finished) return;

        // 1. 關閉 BGM（關掉標題音樂）
        AudioManager.stopBgm();

        // 2. 讓畫面變黑（不會再幫你變亮，之後交給你的自動事件處理）
        $gameScreen.startTint([0, 0, 0, 255], 0);

        // 3. 顯示問題 + 選項（依語言切換文字）
        var t = ngpTexts();

        $gameMessage.add(t.question);

        var choices = [t.yes, t.no];
        var defaultType = 0; // 預設選第一個
        var cancelType  = -1; // 取消等同於 No

        $gameMessage.setChoices(choices, defaultType, cancelType);
        $gameMessage.setChoiceCallback(function(n) {
            if (n === 0) {
                // 選擇「繼承資料開始遊戲 / データを引き継いで始める」
                applyNgpData();
            }
            // 選 No → 什麼都不做，維持普通一周目
            // 問完之後不改色調，由你的第一個自動事件接續處理畫面
        });
    };

})();